﻿
$(function() {
    'use strict';

    BWA.Popup = BWA.Popup || {};
    BWA.Popup.FormulaPointPopup = {

        //create: function(viewModel, selectedTreeItem) {
        create: function (viewModel) {
            
            var popupVisible = ko.observable(false);

            var facilityTypeDataSource = BemsWebApplication.db.createDataSource('BemsFacilityType'),
                serviceTypeDataSource = BemsWebApplication.db.createDataSource('BemsServiceType'),
                fuelTypeDataSource = BemsWebApplication.db.createDataSource('BemsFuelType'),
                pointBaseDataDataSource = BemsWebApplication.db.createDataSource('BemsMonitoringPointBaseData'),

                serviceTypes = ko.observableArray(),
                fuelTypes = ko.observableArray(),
                properties = ko.observableArray(),
                valueTypes = $G.ValueTypes,

                eq = BWA.DataUtil.constructEqualFilter,
                and = BWA.DataUtil.andFilter,
                viewModel = viewModel,
                dataModel = viewModel.dataModel = new BemsWebApplication.BemsMonitoringPointViewModel();

            dataModel.FacilityTypeName = ko.observable();
            dataModel.ServiceTypeName = ko.observable();
            dataModel.ValueTypeName = ko.observable();
            dataModel.FuelTypeName = ko.observable();
            dataModel.FacilityName = ko.observable();            
            
            function getDoneFunc(koObservableArray) {

                return function(dbArray) {

                    koObservableArray(dbArray);
                };
            }

            function handleInitializeDataModelValue(dataModel) {

              
            }

            function handleSelectBoxChangeProperty(e) {

                var property = _.find(properties(), function(x) {

                    return x.PropertyId() === e.value;
                });
                if (property) {
                    
                    dataModel.Name(property.Name());
                }
            }

            function handleDataGridRowClick(id, dataGrid, clickRow) {
                var data = clickRow.data;

                var valueType = _.find(valueTypes, function (x) {
                    return x.ValueType === data.ValueType();
                });

                dataModel.FacilityName(data['CmFacility/Name']());
                dataModel.FacilityTypeName(data['BemsFacilityType/Name']());
                dataModel.ServiceTypeName(data['BemsServiceType/Name']());
                dataModel.FuelTypeName(data['BemsFuelType/Name']());
                dataModel.ValueTypeName(valueType.Name);
                dataModel.Name(data.Name());
                dataModel.PropertyId(data.PropertyId());
                dataModel.Description(data.Description());

                popupVisible(true);
            }

            function handlePopupButtonClose() {
                popupVisible(false);
            }

            function handlePopupShowing(e) {
                //var item = selectedTreeItem();
                //if (item.depth !== 2) return;

                //var facility = item.data;

                //dataModel.SiteId(facility.SiteId());
                //dataModel.FacilityCode(facility.FacilityCode());
                //dataModel.FacilityTypeId(facility.FacilityTypeId());
                //dataModel.FacilityTypeName(facility['BemsFacilityType/Name']());
                //dataModel.FacilityName(facility.Name());
                ////dataModel.IsAccumulated(true);

                //pointBaseDataDataSource.filter([
                //    eq('FacilityTypeId', dataModel.FacilityTypeId())
                //]);
                //pointBaseDataDataSource.load().done(getDoneFunc(properties));

                //var data = clickRow.data;

                //var valueType = _.find(valueTypes, function(x) {
                //    return x.ValueType === data.ValueType();
                //});

              
                //

                //popupVisible(true);
            }

            function handlePopupShown() {

            }

            var toolbarItems = [
                { location: 'before', text: $G('point') },
                { location: 'after', widget: 'button', options: { text: $G('close'), icon: 'close', clickAction: handlePopupButtonClose } }
            ];

            var popupOptions = {

                width: '520px',
                height: 'auto',
                visible: popupVisible,
                closeOnOutsideClick: false,
                shading: false,
                showingAction: handlePopupShowing,
                shownAction: handlePopupShown,
                animation: utils.popup.createAnimation()
            };


            return {

                popupOptions: popupOptions,
                toolbarItems: toolbarItems,

                serviceTypes: serviceTypes,
                fuelTypes: fuelTypes,
                properties: properties,
                valueTypes: valueTypes,
                
                handleDataGridRowClick: handleDataGridRowClick,
                handleSelectBoxChangeProperty: handleSelectBoxChangeProperty,
                handleInitializeDataModelValue: handleInitializeDataModelValue,

                show: function () {
                    popupVisible(true);
                }
            };
        }
    }
});
